/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.rc;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class PlatformDetector {
    private static final String g = "Unknown";
    public static final int i = -1;
    public static final int h = 0;
    public static final int f = 1;
    public static final int e = 2;
    private static int c = -1;
    private static String b = "Unknown";
    private static Boolean d = null;

    private PlatformDetector() {
    }

    public static synchronized boolean isWin32() {
        if (c == -1) {
            c = PlatformDetector.b();
        }
        return c == 0;
    }

    public static synchronized boolean isMacOS() {
        if (c == -1) {
            c = PlatformDetector.b();
        }
        return c == 1;
    }

    public static synchronized boolean isLinux() {
        if (c == -1) {
            c = PlatformDetector.b();
        }
        return c == 2;
    }

    public static synchronized String getVersion() {
        if (b == g) {
            b = System.getProperty("os.version");
        }
        return b;
    }

    private static synchronized int b() {
        if (System.getProperty("os.name").toUpperCase().startsWith("WIN")) {
            return 0;
        }
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC OS")) {
            return 1;
        }
        return 2;
    }

    public static synchronized boolean isWinXP() {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                bl = rc.f(System.getProperty("os.version")) == 5.1f;
            }
            catch (Exception exception) {
                String string = System.getProperty("os.name").toUpperCase();
                bl = string.endsWith("XP") || string.endsWith("2003");
            }
        }
        return bl;
    }

    public static synchronized boolean isWinXPOrLater() {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                bl = rc.f(System.getProperty("os.version")) >= 5.1f;
            }
            catch (Exception exception) {
                String string = System.getProperty("os.name").toUpperCase();
                bl = string.endsWith("XP") || string.endsWith("2003") || string.endsWith("VISTA") || string.endsWith("2008") || string.endsWith(" 7");
            }
        }
        return bl;
    }

    public static synchronized boolean isWinVista() {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                bl = rc.f(System.getProperty("os.version")) == 6.0f;
            }
            catch (Exception exception) {
                String string = System.getProperty("os.name").toUpperCase();
                bl = string.endsWith("VISTA");
            }
        }
        return bl;
    }

    public static synchronized boolean isWinVistaOrLater() {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                bl = rc.f(System.getProperty("os.version")) >= 6.0f;
            }
            catch (Exception exception) {
                String string = System.getProperty("os.name").toUpperCase();
                bl = string.endsWith("VISTA") || string.endsWith("2008") || string.endsWith(" 7");
            }
        }
        return bl;
    }

    public static synchronized boolean isWin7() {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                bl = rc.f(System.getProperty("os.version")) == 6.1f;
            }
            catch (Exception exception) {
                String string = System.getProperty("os.name").toUpperCase();
                bl = string.endsWith(" 7");
            }
        }
        return bl;
    }

    public static synchronized boolean isMacOS_10_7_orGreater() {
        boolean bl = PlatformDetector.isMacOS();
        if (bl) {
            String string = System.getProperty("os.version");
            bl = string != null && string.compareTo("10.7") >= 0;
        }
        return bl;
    }

    public static synchronized void setType(int n2) {
        c = n2;
    }

    public static synchronized int getType() {
        if (c == -1) {
            c = PlatformDetector.b();
        }
        return c;
    }

    public static synchronized boolean isEclipse() {
        if (d == null) {
            d = "true".equalsIgnoreCase(System.getProperty("com.oxygenxml.is.eclipse.plugin"));
        }
        return d;
    }

    public static synchronized void resetIsEclipseFromTC() {
        d = null;
    }
}

