/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsl.documentation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.options.od;
import ro.sync.io.FileSystemUtil;
import ro.sync.options.z;
import ro.sync.util.Resource;
import ro.sync.util.URLUtil;
import ro.sync.xsd.documentation.DocumentationOptions;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XSLDocumentationOptions
extends DocumentationOptions {
    public static final URL HTML_XSL = Resource.getResource("/builtin/documentation/stylesheet_documentation/xslDocHtml.xsl");
    public static URL[] XSL_HTML_IMAGES = new URL[]{Resource.getResource("/builtin/documentation/img/tplN12.gif"), Resource.getResource("/builtin/documentation/img/tplN16.gif")};
    private static Logger logger = Logger.getLogger((String)XSLDocumentationOptions.class.getName());
    private boolean includeTemplates = true;
    private boolean includeFunctions = true;
    private boolean includeVariables = true;
    private boolean includeGlobalParameters = true;
    private boolean includeAttributeSets = true;
    private boolean includeCharacterMaps = true;
    private boolean includeKeys = true;
    private boolean includeOutputs = true;
    private boolean includeDecimalFormats = true;
    private boolean includeImportedIncludedStylesheets = true;
    private boolean detailsNamespace = true;
    private boolean detailsLocation = true;
    private boolean detailsParameters = true;
    private boolean detailsSource = true;
    private boolean detailsReferences = true;
    private boolean detailsSupersedes = true;
    private boolean detailsReturnType = true;
    private boolean detailsOverriding = true;
    private boolean detailsUsedBy = true;
    private boolean detailsDocumentation = true;
    private boolean detailsDocumentationUseComments = true;
    private boolean detailsImportPrecedence = false;

    public XSLDocumentationOptions() {
    }

    public XSLDocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, boolean bl23, boolean bl24, boolean bl25) {
        this(string, n2, bl, n3, uRL, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, bl20, bl21, bl22, bl23, bl24, bl25, false, null);
    }

    public XSLDocumentationOptions(String string, int n2, boolean bl, int n3, URL uRL, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, boolean bl21, boolean bl22, boolean bl23, boolean bl24, boolean bl25, boolean bl26, URL uRL2) {
        super(string, n2, bl, n3, uRL, bl2, bl3, bl26, uRL2);
        this.includeTemplates = bl4;
        this.includeFunctions = bl5;
        this.includeVariables = bl6;
        this.includeGlobalParameters = bl7;
        this.includeAttributeSets = bl8;
        this.includeCharacterMaps = bl9;
        this.includeKeys = bl10;
        this.includeOutputs = bl11;
        this.includeDecimalFormats = bl12;
        this.includeImportedIncludedStylesheets = bl13;
        this.detailsNamespace = bl14;
        this.detailsLocation = bl15;
        this.detailsParameters = bl16;
        this.detailsSource = bl17;
        this.detailsImportPrecedence = bl18;
        this.detailsReferences = bl19;
        this.detailsSupersedes = bl20;
        this.detailsReturnType = bl21;
        this.detailsOverriding = bl22;
        this.detailsUsedBy = bl23;
        this.detailsDocumentation = bl24;
        this.detailsDocumentationUseComments = bl25;
    }

    @Override
    public URL getXSL() {
        URL uRL = null;
        uRL = this.format == 4 ? this.getCustomURL() : HTML_XSL;
        return uRL;
    }

    public boolean isIncludeTemplates() {
        return this.includeTemplates;
    }

    public boolean isIncludeFunctions() {
        return this.includeFunctions;
    }

    public boolean isIncludeVariables() {
        return this.includeVariables;
    }

    public boolean isIncludeGlobalParameters() {
        return this.includeGlobalParameters;
    }

    public boolean isIncludeAttributeSets() {
        return this.includeAttributeSets;
    }

    public boolean isIncludeCharacterMaps() {
        return this.includeCharacterMaps;
    }

    public boolean isIncludeKeys() {
        return this.includeKeys;
    }

    public boolean isIncludeOutputs() {
        return this.includeOutputs;
    }

    public boolean isIncludeDecimalFormats() {
        return this.includeDecimalFormats;
    }

    public boolean isDetailsNamespace() {
        return this.detailsNamespace;
    }

    public boolean isDetailsLocation() {
        return this.detailsLocation;
    }

    public boolean isDetailsParameters() {
        return this.detailsParameters;
    }

    public boolean isDetailsSource() {
        return this.detailsSource;
    }

    public boolean isDetailsReferences() {
        return this.detailsReferences;
    }

    public boolean isDetailsSupersedes() {
        return this.detailsSupersedes;
    }

    public boolean isDetailsReturnType() {
        return this.detailsReturnType;
    }

    public boolean isDetailsOverriding() {
        return this.detailsOverriding;
    }

    public boolean isDetailsUsedBy() {
        return this.detailsUsedBy;
    }

    public boolean isDetailsDocumentation() {
        return this.detailsDocumentation;
    }

    public boolean isDetailsDocumentationUseComments() {
        return this.detailsDocumentationUseComments;
    }

    public boolean isIncludeImportedIncludedStylesheets() {
        return this.includeImportedIncludedStylesheets;
    }

    public static void copyXslHTMLImages(File file) {
        DocumentationOptions.copyImages(file, HTML_IMAGES);
        file = new File(file, IMAGES_DIRECTORY);
        if (!file.exists()) {
            file.mkdir();
        }
        for (int i2 = 0; i2 < XSL_HTML_IMAGES.length; ++i2) {
            File file2 = new File(file, URLUtil.extractFileName(XSL_HTML_IMAGES[i2]));
            try {
                FileSystemUtil.copyInputStreamToOutputStream(XSL_HTML_IMAGES[i2].openStream(), new FileOutputStream(file2), true);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error((Object)fileNotFoundException, (Throwable)fileNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
    }

    public boolean isDetailsImportPrecedence() {
        return this.detailsImportPrecedence;
    }

    public void setIncludeTemplates(boolean bl) {
        this.includeTemplates = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(File file) throws IOException {
        file = URLUtil.correctFileExtension(file, "xml");
        z z2 = new z(false, od.b);
        z2.setObjectProperty("xsl.documentation.options", this);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            z2.store(outputStream);
        }
        finally {
            block9: {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)iOException, (Throwable)iOException);
                    }
                }
            }
        }
    }
}

