/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xsl.documentation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.Oxygen;
import ro.sync.exml.editor.xmleditor.ErrorListException;
import ro.sync.exml.f;
import ro.sync.exml.options.od;
import ro.sync.licensemanager.j;
import ro.sync.licensemanager.v;
import ro.sync.net.protocol.Installer;
import ro.sync.options.z;
import ro.sync.ui.application.b.l;
import ro.sync.util.PlatformDetector;
import ro.sync.util.Resource;
import ro.sync.util.URLUtil;
import ro.sync.util.c.c;
import ro.sync.util.ec;
import ro.sync.util.kc;
import ro.sync.xsd.documentation.n;
import ro.sync.xsl.documentation.XSLDocumentationOptions;
import ro.sync.xsl.documentation.g;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class XSLStylesheetDocumentationGenerator {
    private static void d() {
        System.out.println();
        if (PlatformDetector.isWin32()) {
            System.out.print("stylesheetDocumentation ");
        } else if (PlatformDetector.isMacOS()) {
            System.out.print("sh stylesheetDocumentationMac.sh ");
        } else {
            System.out.print("sh stylesheetDocumentation.sh ");
        }
        System.out.println("xslFile [ [-cfg:configFile] | [[-out:outputFile] [-format:<value>] [-xsl:customFormatXslFile] [-split:<value>] [-openInBrowser:<value>]] | [-help | --help | -h | --h]\n");
        System.out.println("Where:");
        System.out.println("   stylesheetFile = the XSL file");
        System.out.println("   -cfg:configfile = the configuration file.      It contains the output file, split method, output format options\n     and some advanced options regarding the included components and components details.\n     If an external configuration file is specified all other supplied arguments except the XSL file will be ignored.\n     You can create such a file in the Oxygen \"XSL Stylesheet Documentation\" dialog. See the Oxygen user manual for additional information on how to create one.\n");
        System.out.println("   -out:outputFile = the file where the generated documentation will be saved.\n     By default it is the name of the stylesheet file with 'html' extension.");
        System.out.println("   -format:<value> = the output format type used when generating the documentation.\n     value = [html | custom]\n             html    = generate documentation in HTML format.\n             custom  = generate documentation in a custom format.\n");
        System.out.println("   -xsl:<customFormatXslFile> = the XSL file to be applied on the intermediate xml format. \n     If there is no xsl file provided then the result will be in the HTML format.");
        System.out.println("   -split:<value>  = the split method used when generating the documentation. Splitting is recommended for large stylesheets\n     value = [none | component | location].\n             none      = generate one single output file.\n             component = generate an output file for every component in the stylesheet.\n             location  = generate an output file for every stylesheet location.\n     By default the used method is 'none'");
        System.out.println("   -openInBrowser:<value> = open the result of the transformation in browser.\n     value = [true | false].\n             true = open the resulted file in browser.\n             false = do not open the resulted file in browser.\n     By default the value is false.\n\n   -help | --help | -h | --h = show this help.");
        System.out.println();
        System.out.print("Example: ");
        if (PlatformDetector.isWin32()) {
            System.out.print("stylesheetDocumentation ");
        } else if (PlatformDetector.isMacOS()) {
            System.out.print("sh stylesheetDocumentationMac.sh ");
        } else {
            System.out.print("sh stylesheetDocumentation.sh ");
        }
        System.out.println("example.xsl -out:stylesheetDocumentation.html -format:custom -xsl:customFormat.xsl -split:location");
        System.exit(1);
    }

    private static int c(String string) {
        int n2 = -1;
        if ("none".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("component".equals(string)) {
            n2 = 4;
        } else if ("location".equals(string)) {
            n2 = 3;
        } else {
            System.out.println("Invalid split method!");
            XSLStylesheetDocumentationGenerator.d();
        }
        return n2;
    }

    private static int e(String string) {
        int n2 = -1;
        if ("html".equals(string = string.substring(string.indexOf(58) + 1))) {
            n2 = 1;
        } else if ("custom".equals(string)) {
            n2 = 4;
        } else {
            System.out.println("Invalid output format type!");
            XSLStylesheetDocumentationGenerator.d();
        }
        return n2;
    }

    public static void main(String[] stringArray) throws MalformedURLException, IOException, ParserConfigurationException, TransformerException {
        boolean bl = c.c();
        ec.b();
        Installer.installProtocols();
        File file = Resource.getLibDir();
        Oxygen.setOxygenHome(file);
        kc.j(l.e().m());
        f f2 = new f(new String[]{"XML-Developer", "XML-Editor"});
        j j2 = f2.licenseCheck(false);
        c.b(bl);
        if (j2 == null) {
            System.err.println("ERROR: No valid oXygen license found, documentation generation aborted...:");
            System.err.println("--------------------------------------------------");
            System.err.println("Please register a valid license key in one of the following ways:");
            System.err.println("    1) Start oXygen and enter a valid license key for registration");
            System.err.println("    2) Place the license key in a file named \"licensekey.txt\" in the same directory as this script");
            System.err.println("--------------------------------------------------");
            System.exit(1);
        } else {
            Object object;
            v.k().b(j2);
            URL uRL = null;
            XSLDocumentationOptions xSLDocumentationOptions = null;
            if (stringArray.length < 1 || stringArray.length > 6) {
                System.out.println("Invalid number of arguments!");
                XSLStylesheetDocumentationGenerator.d();
            } else if (stringArray.length == 1 && ("--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0]) || "-h".equals(stringArray[0]))) {
                XSLStylesheetDocumentationGenerator.d();
            } else {
                block15: {
                    object = stringArray[0];
                    try {
                        uRL = new URL(URLUtil.correct((String)object, false));
                    }
                    catch (MalformedURLException malformedURLException) {
                        File file2 = new File((String)object);
                        if (!file2.isFile() || !file2.exists()) break block15;
                        try {
                            uRL = URLUtil.correct(file2);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            // empty catch block
                        }
                    }
                }
                if (uRL == null) {
                    System.out.println("The specified stylesheet file does not exist!");
                    XSLStylesheetDocumentationGenerator.d();
                } else {
                    xSLDocumentationOptions = XSLStylesheetDocumentationGenerator.b(stringArray, uRL);
                }
            }
            if (xSLDocumentationOptions != null) {
                object = new g();
                try {
                    ((g)object).b(uRL, xSLDocumentationOptions, false);
                    System.out.println("Stylesheet documentation generation successful.");
                }
                catch (ErrorListException errorListException) {
                    System.out.println(n.l(errorListException.getErrorList(), "Stylesheet documentation generation failed: "));
                    System.exit(1);
                }
            }
        }
        System.exit(0);
    }

    static XSLDocumentationOptions b(String[] stringArray, URL uRL) throws IOException {
        XSLDocumentationOptions xSLDocumentationOptions = null;
        if (stringArray.length > 1 && stringArray[1].startsWith("-cfg:")) {
            String string = stringArray[1].substring(5);
            if (string.length() > 0) {
                File file = new File(string);
                if (file.exists()) {
                    z z2 = new z(false, od.b);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    z2.load(bufferedInputStream);
                    xSLDocumentationOptions = (XSLDocumentationOptions)z2.getObjectProperty("xsl.documentation.options");
                    if (xSLDocumentationOptions == null) {
                        System.out.println("Invalid configuration file format!");
                    }
                } else {
                    System.out.println("The configuration file '" + file + "' could not be found!");
                }
            } else {
                System.out.println("Invalid configuration file name!");
                XSLStylesheetDocumentationGenerator.d();
            }
        } else {
            String string = "${cfn}.html";
            int n2 = 1;
            File file = null;
            int n3 = 1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = false;
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2.startsWith("-split:")) {
                    if (!bl3) {
                        n3 = XSLStylesheetDocumentationGenerator.c(string2);
                        bl3 = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Split method already specified!");
                    XSLStylesheetDocumentationGenerator.d();
                    break;
                }
                if (string2.startsWith("-format:")) {
                    if (!bl2) {
                        n2 = XSLStylesheetDocumentationGenerator.e(string2);
                        bl2 = true;
                        if (bl) continue;
                        switch (n2) {
                            case 1: {
                                string = "${cfn}.html";
                                break;
                            }
                            case 4: {
                                string = "${cfn}.xml";
                            }
                        }
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Output format type already specified!");
                    XSLStylesheetDocumentationGenerator.d();
                    break;
                }
                if (string2.startsWith("-xsl:")) {
                    if (!bl4) {
                        file = new File(string2.substring(5));
                        bl4 = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Custom stylesheet file already specified!");
                    XSLStylesheetDocumentationGenerator.d();
                    break;
                }
                if (string2.startsWith("-out:")) {
                    if (!bl) {
                        string = string2.substring(5);
                        bl = true;
                        continue;
                    }
                    bl5 = false;
                    System.out.println("Output file already specified!");
                    XSLStylesheetDocumentationGenerator.d();
                    break;
                }
                if (string2.startsWith("-openInBrowser:")) {
                    bl6 = Boolean.valueOf(string2.substring(15));
                    continue;
                }
                bl5 = false;
                System.out.println("Invalid argument: " + string2);
                XSLStylesheetDocumentationGenerator.d();
                break;
            }
            if (bl5) {
                File file2 = new File(string);
                if (!uRL.getProtocol().equals("file") && !file2.isAbsolute()) {
                    bl5 = false;
                    System.out.println("Relative output is not supported for remote schemas. Please specify a local output file!");
                    XSLStylesheetDocumentationGenerator.d();
                } else {
                    xSLDocumentationOptions = new XSLDocumentationOptions();
                    xSLDocumentationOptions.setOutputFile(string);
                    xSLDocumentationOptions.setFormat(n2);
                    xSLDocumentationOptions.setOpenOutputInBrowser(bl6);
                    if (n2 == 4) {
                        if (file != null) {
                            xSLDocumentationOptions.setCustomXSL(URLUtil.correct(file));
                        } else {
                            System.out.println("\nThe custom XSL file has not been specified!\n");
                            XSLStylesheetDocumentationGenerator.d();
                        }
                    }
                    if (n2 == 1 || n2 == 4) {
                        xSLDocumentationOptions.setSplitMethod(n3);
                    } else {
                        xSLDocumentationOptions.setSplitMethod(1);
                    }
                }
            }
        }
        return xSLDocumentationOptions;
    }
}

