  /*
   * DOM Level3 CORE
   */
  /* http://www.w3.org/TR/2004/REC-DOM-Level-3-Core-20040407/core.html#ID-1780488922 */

  /**
   * Provides the abstraction of an ordered collection of  values, 
   * without defining or constraining how this collection is implemented. 
   * The items in the List are accessible via an integral index, starting from 0.
   */
  List.prototype = {
		 /**
		  * The number of s in the list. The range of valid child node indices is 0 to length-1 inclusive. 
		  */
		  length:0,
		 /**
		  * Tests if a string is part of this List.
		  * 
		  * @param str  The string to look for.
		  * @return     true if the string has been found, false otherwise. 
		  */
		 contains:function(str){},
		 /**
		  * Returns the indexth item in the collection. If index is greater than or equal to the number 
		  * of s in the list, this returns null.  
		  * 
		  * @param index  Index into the collection.
		  * @return       The  at the indexth position in the List, 
		  *               or null if that is not a valid index. 
		  */
		 item:function(index){}
  }
  
  /**
   * Provides the abstraction of an ordered collection of parallel pairs of name and 
   * namespace values (which could be null values), without defining or constraining how 
   * this collection is implemented. The items are accessible via an integral index, starting from 0.
   */
  NameList.prototype = {
     /**
      * The number of pairs (name and namespaceURI) in the list. 
      * The range of valid child node indices is 0 to length-1 inclusive.  
      */
     length:0,
     /**
      * Tests if a name is part of this NameList. 
      * 
      * @param str  The name to look for.
      * @return     true if the name has been found, false otherwise. 
      */
     contains:function(str){},
     /**
      * Tests if the pair namespaceURI/name is part of this NameList.
      * 
      * @param nmSpcURI The namespace URI to look for.
      * @param nm       The name to look for.
      * @return         true if the pair namespaceURI/name has been found, false otherwise.  
      */
     containsNS:function(nmSpcURI, nm){},
     /**
      * Returns the indexth name item in the collection. 
      * 
      * @param index  Index into the collection.
      * @return       The name at the indexth position in the NameList, or null    
      *               if there is no name for the specified index or if the index is out of range. 
      */
     getName:function(index){},
     /**
      * Returns the indexth namespaceURI item in the collection. 
      * 
      * @param index  Index into the collection.
      * @return       The namespace URI at the indexth position in the NameList, or null   
      *               if there is no name for the specified index or if the index is out of range. 
      */
     getNamespaceURI:function(index){}
  }
  
  /**
   * Provides the abstraction of an ordered collection of DOM implementations, without defining or 
   * constraining how this collection is implemented.  
   * The items in the DOMImplementationList are accessible via an integral index, starting from 0. 
   */
  DOMImplementationList.prototype = {
     /**
      * The number of DOMImplementations in the list. 
      * The range of valid child node indices is 0 to length-1 inclusive. 
      */
     length :0,
     /**
      * Returns the indexth item in the collection. If index is greater than or equal to the number  
      * of DOMImplementations in the list, this returns null.  
      * 
      * @param index  Index into the collection.
      * @return       The DOMImplementation at the indexth position in the DOMImplementationList,   
      *               or null if that is not a valid index. 
      */
     item:function(index){}
  } 
  
  /**
   * Permits a DOM implementer to supply one or more implementations, based upon requested features 
   * and versions, as specified in DOM Features. Each implemented DOMImplementationSource object 
   * is listed in the binding-specific list of available sources so that its DOMImplementation 
   * objects are made available. 
   */
  DOMImplementationSource.prototype = {
     /**
      * Gets the first DOM implementation that supports the specified features.  
      * 
      * @param f        A string that specifies which features and versions are required. 
      *                 This is a space separated list in which each feature is specified by 
      *                 its name optionally followed by a space and a version number. 
      * @return         The first DOM implementation that support the desired features,    
      *                 or null if this source has none. 
      */
     getDOMImplementation:function(f){},
     /**
      * Gets a list of DOM implementations that support the specified features and versions, 
      * as specified in DOM Features.  
      * 
      * @param f        A string that specifies which features and versions are required. 
      *                 This is a space separated list in which each feature is specified by 
      *                 its name optionally followed by a space and a version number.
      * @return         A list of DOM implementations that support the desired features.   
      */
     getDOMImplementationList:function(f){}
  } 
  
  /**
   * Provides a number of methods for performing operations that are independent of 
   * any particular instance of the document object model. 
   */
  DOMImplementation.prototype = {
     /**
      * Creates a DOM Document object of the specified type with its document element.  
      * 
      * @param n    The namespace URI of the document element to create or null. 
      * @param q    The qualified name of the document element to be created or null.
      * @param d    The type of document to be created or null.
      * @return     A new Document object with its document element. 
      *             If the NamespaceURI, qualifiedName, and doctype are null, 
      *             the returned Document is empty with no document element.    
      */
     createDocument:function(n, q, d){},
     /**
      * Creates an empty DocumentType node. Entity declarations and notations are not made available. 
      * Entity reference expansions and default attribute additions do not occur.  
      * 
      * @param q            The qualified name of the document type to be created. 
      * @param p            The external subset public identifier.
      * @param s            The external subset system identifier.
      * @return             A new DocumentType node with Node.ownerDocument set to null.   
      */
     createDocumentType:function(q, p, s){},
     /**
      * Returns a specialized object which implements the specialized APIs of the specified feature 
      * and version, as specified in DOM Features.  
      * 
      * @param ft  The name of the feature requested. 
      * @param vs  The version number of the feature to test.  
      * @return    Returns an object which implements the specialized APIs of the specified 
      *            feature and version, if any, or null if there is no object which 
      *            implements interfaces associated with that feature.          
      */
     getFeature:function(ft, vs){},
     /**
      * Tests if the DOM implementation implements a specific feature and version, 
      * as specified in DOM Features.  
      * 
      * @param ft  The name of the feature to test.  
      * @param vs  The version number of the feature to test. 
      * @return    true if the feature is implemented in the specified version, false otherwise.   
      */
     hasFeature:function(ft, vs){}
  }

  /**
   * Is a "lightweight" or "minimal" Document object. 
   */
  DOMFragment.prototype = {}
  
  /**
   * Represents the entire HTML or XML document. Conceptually, it is the root of the document tree, 
   * and provides the primary access to the document's data. 
   */
  Document.prototype = {
     /**
      * The Document Type Declaration (see DocumentType) associated with this document. 
      * For XML documents without a document type declaration this returns null. 
      */
     doctype:0,
     /**
      * A convenience attribute that allows direct access to the child node 
      * that is the document element of the document. 
      */
     documentElement:0,
     /**
      * The location of the document or null if undefined or if the Document was created 
      * using DOMImplementation.createDocument. 
      */
     documentURI:0,
     /**
      * The configuration used when Document.normalizeDocument() is invoked. 
      */
     domConfig:0,
     /**
      * The DOMImplementation object that handles this document. 
      */
     implementation:0,
     /**
      * Specifies the encoding used for this document at the time of the parsing. 
      * This is null when it is not known, such as when the Document was created in memory. 
      */
     inputEncoding:0,
     /**
      * Specifies whether error checking is enforced or not. When set to false, the implementation 
      * is free to not test every possible error case normally defined on DOM operations 
      */
     strictErrorChecking:0,
     /**
      * Specifies, as part of the XML declaration, the encoding of this document. This is null
      * when unspecified or when it is not known, such as when the Document was created in memory. 
      */
     xmlEncoding:0,
     /**
      * Specifies, as part of the XML declaration, whether this document is standalone. 
      * This is false when unspecified. 
      */
     xmlStandalone:0,
     /**
      * Specifies, as part of the XML declaration, the version number of this document. 
      * If there is no declaration and if this document supports the "XML" feature, the value is "1.0". 
      * If this document does not support the "XML" feature, the value is always null. 
      */
     xmlVersion:0,
     /**
      * Attempts to adopt a node from another document to this document. If supported, 
      * it changes the ownerDocument of the source node, its children, 
      * as well as the attached attribute nodes if there are any.  
      * 
      * @param source The node to move into this document.
      * @return       The adopted node, or null if this operation fails, such as when 
      *               the source node comes from a different implementation. 
      */
     adoptNode:function(source){},
     /**
      * Creates an Attr of the given name.  
      * 
      * @param name The name of the attribute. 
      * @return     A new Attr object with the nodeName attribute set to name, and 
      *             localName, prefix, and namespaceURI set to null. 
      *             The value of the attribute is the empty string.   
      */
     createAttribute:function(name){},
     /**
      * Creates an attribute of the given qualified name and namespace URI.  
      * 
      * @param nmSpcURI       The namespace URI of the attribute to create. 
      * @param qName          The qualified name of the attribute to instantiate.  
      * @return               A new Attr object with the following attributes: 
      *                         - qualifiedName, 
      *                         - namespaceURI, 
      *                         - prefix, extracted from qualifiedName, or null if there is no prefix, 
      *                         - local name, extracted from qualifiedName,
      *                         - qualifiedName,
      *                         - the empty string.   
      */
     createAttributeNS:function(nmSpcURI, qName){},
     /**
      * Creates a CDATASection node whose value is the specified string.  
      * 
      * @param data The data for the CDATASection contents. 
      * @return     The new CDATASection object.   
      */
     createCDATASection:function(data){},
     /**
      * Creates a Comment node given the specified string.  
      * 
      * @param data The data for the node.
      * @return     The new Comment object.   
      */
     createComment:function(data){},
     /**
      * Creates an empty DocumentFragment object.
      * 
      * @return A new DocumentFragment.   
      */
     createDocumentFragment:function(){},
     /**
      * Creates an element of the type specified.  
      * 
      * @param tagName  The name of the element type to instantiate.  
      * @return         A new Element object with the nodeName attribute set to tagName, 
      *                 and localName, prefix, and namespaceURI set to null.   
      */
     createElement:function(tagName){},
     /**
      * Creates an element of the given qualified name and namespace URI.
      * 
      * @param nmSpcURI       The namespace URI of the element to create.  
      * @param qName          The qualified name of the element type to instantiate. 
      * @return               A new Element object with the following attributes:
      *                         - qualifiedName, 
      *                         - namespaceURI, 
      *                         - prefix, extracted from qualifiedName, or null if there is no prefix, 
      *                         - local name, extracted from qualifiedName,
      *                         - qualifiedName.
      */
     createElementNS:function(nmSpcURI, qName){},
     /**
      * Creates an EntityReference object. 
      * 
      * @param name The name of the entity to reference. 
      * @return     The new EntityReference object.   
      */
     createEntityReference:function(name){},
     /**
      * Creates a ProcessingInstruction node given the specified name and data strings.  
      * 
      * @param t The target part of the processing instruction. 
      * @param d The data for the node.  
      * @return  The new ProcessingInstruction object. 
      */
     createProcessingInstruction:function(t, d){},
     /**
      * Creates a Text node given the specified string.  
      * 
      * @param data The data for the node.  
      * @return     The new Text object.   
      */
     createTextNode:function(data){},
     /**
      * Returns the Element that has an ID attribute with the given value. 
      * If no such element exists, this returns null.  
      * 
      * @param elementId  The unique id value for an element. 
      * @return           The matching element or null if there is none. 
      */
     getElementById:function(elementId){},
     /**
      * Returns a NodeList of all the Elements in document order with a given tag name 
      * that are contained in the document.  
      * 
      * @param tn  The name of the tag to match on. 
      * @return    A new NodeList object containing all the matched Elements.   
      */
     getElementsByTagName:function(tn){},
     /**
      * Returns a NodeList of all the Elements with a given local name and namespace URI in document order.  
      * 
      * @param ns    The namespace URI of the elements to match on.  
      * @param nl    The local name of the elements to match on. 
      * @return      A new NodeList object containing all the matched Elements.   
      */
     getElementsByTagNameNS:function(ns, nl){},
     /**
      * Imports a node from another document to this document, without altering or 
      * removing the source node from the original document; this method creates 
      * a new copy of the source node. The returned node has no parent.  
      * 
      * @param impNodeq     The node to import. 
      * @param deep         If true, recursively import the subtree under the specified node; 
      *                     if false, import only the node itself, as explained above.
      * @return             The imported node that belongs to this Document.   
      */
     importNode:function(impNode, deep){},
     /**
      * Acts as if the document was going through a save and load cycle, putting the document 
      * in a "normal" form. As a consequence, this method updates the replacement tree of 
      * EntityReference nodes and normalizes Text nodes, as defined in the method Node.normalize().   
      */
     normalizeDocument:function(){},
     /**
      * Rename an existing node of type ELEMENT_NODE or ATTRIBUTE_NODE.  
      * 
      * @param n              The node to rename.  
      * @param nmSpcURI       The new namespace URI.
      * @param qName          The new qualified name.
      * @return               The renamed node. This is either the specified node or the new node 
      *                       that was created to replace the specified node.   
      */
     renameNode:function(n, nmSpcURI, qName){}
  }
  
  /**
   * The primary datatype for the entire Document Object Model. 
   * It represents a single node in the document tree. 
   */
  Node.prototype = {
     /**
      * Contains the attributes of this node (if it is an Element) or null otherwise. 
      */
     attributes:0,
     /**
      * The absolute base URI of this node or null if the implementation wasn't able to obtain an absolute URI. 
      */
     baseURI:0,
     /**
      * Contains all children of this node. If there are no children, this is a NodeList containing no nodes. 
      */
     childNodes:0,
     /**
      * The first child of this node. If there is no such node, this returns null. 
      */
     firstChild:0,
     /**
      * The last child of this node. If there is no such node, this returns null. 
      */
     lastChild:0,
     /**
      * Returns the local part of the qualified name of this node. 
      */
     localName:0,
     /**
      * The namespace URI of this node, or null if it is unspecified. 
      */
     namespaceURI:0,
     /**
      * The node immediately following this node. If there is no such node, this returns null. 
      */
     nextSibling:0,
     /**
      * The name of this node, depending on its type. 
      */
     nodeName:0,
     /**
      * A code representing the type of the underlying object. 
      */
     nodeType:0,
     /**
      * The value of this node, depending on its type. 
      */
     nodeValue:0,
     /**
      * The Document object associated with this node. This is also the Document object used to create new nodes. 
      * When this node is a Document or a DocumentType which is not used with any Document yet, this is null. 
      */
     ownerDocument:0,
     /**
      * The parent of this node. 
      */
     parentNode:0,
     /**
      * The namespace prefix of this node, or null if it is unspecified. 
      */
     prefix:0,
     /**
      * The node immediately preceding this node. If there is no such node, this returns null. 
      */
     previousSibling:0,
     /**
      * Returns the text content of this node and its descendants. 
      */
     textContent:0,
     /**
      * Adds the node newChild to the end of the list of children of this node. 
      * If the newChild is already in the tree, it is first removed.  
      * 
      * @param newChild The node to add.
      * @return         The node added. 
      */
     appendChild:function(newChild){},
     /**
      * Returns a duplicate of this node, i.e., serves as a generic copy constructor for nodes. 
      * The duplicate node has no parent (parentNode is null) and no user data.  
      * 
      * @param deep If true, recursively clone the subtree under the specified node; 
      *             if false, clone only the node itself (and its attributes, if it is an Element). 
      * @return     The duplicate node. 
      */
     cloneNode:function(deep){},
     /**
      * Compares the reference node, i.e. the node on which this method is being called, with a node, 
      * i.e. the one passed as a parameter, with regard to their position in the document and 
      * according to the document order.  
      * 
      * @param other  The node to compare against the reference node. 
      * @return       Returns how the node is positioned relatively to the reference node. 
      */
     compareDocumentPosition:function(other){},
     /**
      * Returns a specialized object which implements the specialized APIs of 
      * the specified feature and version, as specified in DOM Features.  
      * 
      * @param feature  The name of the feature requested. 
      * @param version  The version number of the feature to test. 
      * @return         An object which implements the specialized APIs of the specified feature and 
      *                 version, if any, or null if there is no object which implements interfaces 
      *                 associated with that feature.    
      */
     getFeature:function(feature, version){},
     /**
      * Retrieves the object associated to a key on this node. The object must first have been set 
      * to this node by calling setUserData with the same key.  
      * 
      * @param key  The key the object is associated to.
      * @return     Returns the DOMUserData associated to the given key on this node, 
      *             or null if there was none.   
      */
     getUserData:function(key){},
     /**
      * Returns whether this node (if it is an element) has any attributes. 
      * 
      * @return true if this node has any attributes, false otherwise.   
      */
     hasAttributes:function(){},
     /**
      * Returns whether this node has any children.  
      * 
      * @return Returns true if this node has any children, false otherwise. 
      */
     hasChildNodes:function(){},
     /**
      * Inserts the node newChild before the existing child node refChild. 
      * If refChild is null, insert newChild at the end of the list of children.  
      * 
      * @param newChild The node to insert.  
      * @param refChild The reference node, i.e., the node before which the new node must be inserted. 
      * @return         The node being inserted.
      */
     insertBefore:function(newChild, refChild){},
     /**
      * Checks if the specified namespaceURI is the default namespace or not.   
      * 
      * @param namespaceURI The namespace URI to look for. 
      * @return             true if the specified namespaceURI is the default namespace, false otherwise.   
      */
     isDefaultNamespace:function(namespaceURI){},
     /**
      * Tests whether two nodes are equal.  
      * 
      * @param arg  The node to compare equality with. 
      * @return     true if the nodes are equal, false otherwise. 
      */
     isEqualNode:function(arg){},
     /**
      * Returns whether this node is the same node as the given one.  
      * 
      * @param other  The node to test against.  
      * @return       true if the nodes are the same, false otherwise.   
      */
     isSameNode:function(other){},
     /**
      * Tests whether the DOM implementation implements a specific feature and 
      * that feature is supported by this node, as specified in DOM Features.   
      * 
      * @param feature  The name of the feature to test.
      * @param version  The version number of the feature to test. 
      * @return         true if the specified feature is supported on this node, false otherwise. 
      */
     isSupported:function(feature, version){},
     /**
      * Looks up the namespace URI associated to the given prefix, starting from this node.  
      * 
      * @param prefix The prefix to look for. If this parameter is null, 
      *               the method will return the default namespace URI if any. 
      * @return       The associated namespace URI or null if none is found.   
      */
     lookupNamespaceURI:function(prefix){},
     /**
      * Looks up the prefix associated to the given namespace URI, starting from this node.  
      * 
      * @param nmSpcURI     The namespace URI to look for.  
      * @return             Returns an associated namespace prefix if found or null if none is found. 
      */
     lookupPrefix:function(nmSpcURI){},
     /**
      * Puts all Text nodes in the full depth of the sub-tree underneath this Node, 
      * including attribute nodes, into a "normal" form.  
      */
     normalize:function(){},
     /**
      * Removes the child node indicated by oldChild from the list of children, and returns it.  
      * 
      * @param oldChild The node being removed.  
      * @return         The node removed. 
      */
     removeChild:function(oldChild){},
     /**
      * Replaces the child node oldChild with newChild in the list of children, and returns the oldChild node.  
      * 
      * @param newChild The new node to put in the child list.
      * @param oldChild The node being replaced in the list.  
      * @return         The node replaced. 
      */
     replaceChild:function(newChild, oldChild){},
     /**
      * Associates an object to a key on this node. The object can later be retrieved from this node 
      * by calling getUserData with the same key.  
      * 
      * @param key      The key to associate the object to.
      * @param data     The object to associate to the given key, or null to remove 
      *                 any existing association to that key.
      * @param handler  The handler to associate to that key, or null.  
      * @return         The DOMUserData previously associated to the given key on this node, 
      *                 or null if there was none. 
      */
     setUserData:function(key, data, handler){}
  }

  /**
   * Provides the abstraction of an ordered collection of nodes, without defining or constraining how 
   * this collection is implemented. The items are accessible via an integral index, starting from 0. 
   */
  NodeList.prototype = {
     /**
      * The number of nodes in the list. The range of valid child node indices is 0 to length-1 inclusive. 
      */
     length:0,
     /**
      * Returns the indexth item in the collection.  
      * 
      * @param index  Index into the collection.
      * @return       The node at the indexth position in the NodeList, 
      *               or null if that is not a valid index. 
      */
     item:function(index){}
  }
  
  /**
   * Used to represent collections of nodes that can be accessed by name. 
   */
  NamedNodeMap.prototype = {
     /**
      * The number of nodes in this map. The range of valid child node indices is 0 to length-1 inclusive. 
      */
     length:0,
     /**
      * Retrieves a node specified by name.  
      * 
      * @param name The nodeName of a node to retrieve.
      * @return     A Node (of any type) with the specified nodeName, 
      *             or null if it does not identify any node in this map. 
      */
     getNamedItem:function(name){},
     /**
      * Retrieves a node specified by local name and namespace URI.  
      * 
      * @param nmSpcURI     The namespace URI of the node to retrieve.
      * @param locName      The local name of the node to retrieve.
      * @return             A Node (of any type) with the specified local name and namespace URI, 
      *                     or null if they do not identify any node in this map.               
      */
     getNamedItemNS:function(nmSpcURI, locName){},
     /**
      * Returns the indexth item in the map. If index is greater than or equal to 
      * the number of nodes in this map, this returns null.  
      * 
      * @param index  Index into this map.
      * @return       The node at the indexth position in the map, or null if that is not a valid index. 
      */
     item:function(index){},
     /**
      * Removes a node specified by name.  
      * 
      * @param name The nodeName of the node to remove.
      * @return     The node removed from this map if a node with such a name exists. 
      */
     removeNamedItem:function(name){},
     /**
      * Removes a node specified by local name and namespace URI.  
      * 
      * @param nmSpcURI     The namespace URI of the node to remove.
      * @param locName      The local name of the node to remove.
      * @return             The node removed from this map if a node with such a local name 
      *                     and namespace URI exists. 
      */
     removeNamedItemNS:function(nmSpcURI, locName){},
     /**
      * Adds a node using its nodeName attribute. If a node with that name is already present 
      * in this map, it is replaced by the new one.  
      * 
      * @param arg  A node to store in this map. The node will later be accessible using the value 
      *             of its nodeName attribute.
      * @return     If the new Node replaces an existing node the replaced Node is returned, 
      *             otherwise null is returned.       
      */
     setNamedItem:function(arg){},
     /**
      * Adds a node using its namespaceURI and localName. If a node with that namespace URI and 
      * that local name is already present in this map, it is replaced by the new one. 
      * 
      * @param arg  A node to store in this map. The node will later be accessible using the value 
      *             of its namespaceURI and localName attributes.
      * @return     If the new Node replaces an existing node the replaced Node is returned, 
      *             otherwise null is returned.       
      */
     setNamedItemNS:function(arg){}
  }
  
  /**
   * Extends Node with a set of attributes and methods for accessing character data in the DOM. 
   */
  CharacterData.prototype = {
     /**
      * The character data of the node that implements this interface. 
      */
     data:0,
     /**
      * The number of 16-bit units that are available through data and the substringData method below. 
      * This may have the value zero, i.e., CharacterData nodes may be empty. 
      */
     length:0,
     /**
      * Appends the string to the end of the character data of the node. Upon success, 
      * data provides access to the concatenation of data and the  specified.  
      * 
      * @param arg The  to append.
      */
     appendData:function(arg){},
     /**
      * Removes a range of 16-bit units from the node. Upon success, data and length reflect the change.  
      * 
      * @param offset The offset from which to start removing.
      * @param count  The number of 16-bit units to delete. If the sum of offset and count exceeds 
      *               length then all 16-bit units from offset to the end of the data are deleted.
      */
     deleteData:function(offset, count){},
     /**
      * Inserts a string at the specified 16-bit unit offset.  
      * 
      * @param offset The character offset at which to insert.
      * @param arg    The  to insert.
      */
     insertData:function(offset, arg){},
     /**
      * Replaces the characters starting at the specified 16-bit unit offset with the specified string.  
      * 
      * @param offset The offset from which to start replacing.
      * @param count  The number of 16-bit units to replace.
      * @param arg    The  with which the range must be replaced.
      */
     replaceData:function(offset, count, arg){},
     /**
      * Extracts a range of data from the node.  
      * 
      * @param offset Start offset of substring to extract.
      * @param count  The number of 16-bit units to extract.
      * @return       The specified substring. If the sum of offset and count exceeds the length, 
      *               then all 16-bit units to the end of the data are returned. 
      */
      substringData:function(offset, count){}
  }
  
  /**
   * Represents an attribute in an Element object. 
   */
  Attr.prototype = {
     /**
      * Returns whether this attribute is known to be of type ID or not. 
      */
     isId:0,
     /**
      * Returns the name of this attribute.
      */
     name:0,
     /**
      * The Element node this attribute is attached to or null if this attribute is not in use. 
      */
     ownerElement:0,
     /**
      * The type information associated with this attribute. 
      */
     schemaTypeInfo:0,
     /**
      * True if this attribute was explicitly given a value in the instance document, false otherwise. 
      */
     specified:0,
     /**
      * On retrieval, the value of the attribute is returned as a string. 
      */
     value:0     
  }
  
  /**
   * Represents an element in an HTML or XML document. 
   */
  Element.prototype = {
     /**
      * The type information associated with this element. 
      */
     schemaTypeInfo:0,
     /**
      * The name of the element. If Node.localName is different from null, 
      * this attribute is a qualified name. 
      */
     tagName:0,
     /**
      * Retrieves an attribute value by name.  
      * 
      * @param name The name of the attribute to retrieve.
      * @return     The Attr value as a string, or the empty string if that attribute does not have 
      *             a specified or default value. 
      */
     getAttribute:function(name){},
     /**
      * Retrieves a node specified by local name and namespace URI.  
      * 
      * @param nmSpcURI     The namespace URI of the attribute to retrieve.
      * @param locName      The local name of the attribute to retrieve.
      * @return             The Attr value as a string, or the empty string if that attribute 
      *                     does not have a specified or default value.               
      */
     getAttributeNS:function(nmSpcURI, locName){},
     /**
      * Retrieves an attribute node by name.  
      * 
      * @param name The name (nodeName) of the attribute to retrieve.
      * @return     The Attr node with the specified name (nodeName) 
      *             or null if there is no such attribute. 
      */
     getAttributeNode:function(name){},
     /**
      * Retrieves an Attr node by local name and namespace URI.  
      * 
      * @param nmSpcURI     The namespace URI of the attribute to retrieve.
      * @param locName      The local name of the attribute to retrieve.
      * @return             The Attr node with the specified attribute local name and namespace URI 
      *                     or null if there is no such attribute. 
      */
     getAttributeNodeNS:function(nmSpcURI, locName){},
     /**
      * Returns a NodeList of all descendant Elements with a given tag name, in document order.  
      * 
      * @param name The name of the tag to match on.
      * @return     A list of matching Element nodes. 
      */
     getElementsByTagName:function(name){},
     /**
      * Returns a NodeList of all the descendant Elements with a given local name 
      * and namespace URI in document order.  
      * 
      * @param nmSpcURI     The namespace URI of the elements to match on.
      * @param locName      The local name of the elements to match on.
      * @return             A new NodeList object containing all the matched Elements. 
      */
     getElementsByTagNameNS:function(nmSpcURI, locName){},
     /**
      * Returns true when an attribute with a given name is specified on this element or 
      * has a default value, false otherwise.  
      * 
      * @param name The name of the attribute to look for.
      * @return     true if an attribute with the given name is specified on this element or 
      *             has a default value, false otherwise.       
      */
     hasAttribute:function(name){},
     /**
      * Returns true when an attribute with a given local name and namespace URI is specified on 
      * this element or has a default value, false otherwise.  
      * 
      * @param nmSpcURI     The namespace URI of the attribute to look for.
      * @param locName      The local name of the attribute to look for;
      * @return             true if an attribute with the given local name and namespace URI 
      *                     is specified or has a default value on this element, false otherwise. 
      */
     hasAttributeNS:function(nmSpcURI, locName){},
     /**
      * Removes an attribute by name.  
      * 
      * @param name The name of the attribute to remove.
      */
     removeAttribute:function(name){},
     /**
      * Removes an attribute by local name and namespace URI.  
      * 
      * @param nmSpcURI   The namespace URI of the attribute to remove.
      * @param locName    The local name of the attribute to remove.
      */
     removeAttributeNS:function(nmSpcURI, locName){},
     /**
      * Removes the specified attribute node.  
      * 
      * @param oldAttr  The Attr node to remove from the attribute list. 
      * @return         The Attr node that was removed. 
      */
     removeAttributeNode:function(oldAttr){},
     /**
      * Adds a new attribute. If an attribute with that name is already present in the element, 
      * its value is changed to be that of the value parameter.
      * 
      * @param name   The name of the attribute to create or alter.
      * @param value  Value to set in string form.
      */
     setAttribute:function(name, value){},
     /**
      * Adds a new attribute. If an attribute with the same local name and namespace URI 
      * is already present on the element, its prefix is changed to be the prefix part of 
      * the qualifiedName, and its value is changed to be the value parameter. 
      * 
      * @param nmSpcURI    The namespace URI of the attribute to create or alter.
      * @param qName       The qualified name of the attribute to create or alter.
      * @param value       The value to set in string form.
      */
     setAttributeNS:function(nmSpcURI, qName, value){},
     /**
      * Adds a new attribute node. If an attribute with that name (nodeName) is already present 
      * in the element, it is replaced by the new one. 
      * 
      * @param newAttr  The Attr node to add to the attribute list.
      * @return         If the newAttr attribute replaces an existing attribute, 
      *                 the replaced Attr node is returned, otherwise null is returned.       
      */
     setAttributeNode:function(newAttr){},
     /**
      * Adds a new attribute node. If an attribute with that local name and that namespace URI 
      * is already present in the element, it is replaced by the new one. 
      * 
      * @param newAttr  The Attr node to add to the attribute list.
      * @return         If the newAttr attribute replaces an existing attribute with the same 
      *                 local name and namespace URI, the replaced Attr node is returned, 
      *                 otherwise null is returned.       
      */
     setAttributeNodeNS:function(newAttr){},
     /**
      * If the parameter isId is true, this method declares the specified attribute to be
      * a user-determined ID attribute.
      * 
      * @param name The name of the attribute.
      * @param isId Whether the attribute is a of type ID.
      */
     setIdAttribute:function(name, isId){},
     /**
      * If the parameter isId is true, this method declares the specified attribute to be 
      * a user-determined ID attribute.  
      * 
      * @param nmSpcURI The namespace URI of the attribute.
      * @param locName  The local name of the attribute.
      * @param isId     Whether the attribute is a of type ID.
      */
     setIdAttributeNS:function(nmSpcURI, locName, isId){},
     /**
      * If the parameter isId is true, this method declares the specified attribute to be 
      * a user-determined ID attribute.  
      * 
      * @param idAttr The attribute node.
      * @param isId   Whether the attribute is a of type ID.       
      */
     setIdAttributeNode:function(idAttr, isId){}
  }
  
  /**
   * Represents the textual content of an Element or Attr. 
   */
  Text.prototype = {
     /**
      * Returns whether this text node contains element content whitespace or not. 
      */
     isElementContentWhitespace:0,
     /**
      * Returns all text of Text nodes logically-adjacent text nodes to this node, concatenated in document order. 
      */
     wholeText:0,
     /**
      * Replaces the text of the current node and all logically-adjacent text nodes with the specified text.  
      * 
      * @param content  The content of the replacing Text node.
      * @return         The Text node created with the specified content. 
      */
     replaceWholeText:function(content){},
     /**
      * Breaks this node into two nodes at the specified offset, keeping both in the tree as siblings.  
      * 
      * @param offset The 16-bit unit offset at which to split, starting from 0.
      * @return       The new node, of the same type as this node.               
      */
     splitText:function(offset){}
  }
  
  /**
   * Inherits from CharacterData and represents the content of a comment, i.e., 
   * all the characters between the starting '<!--' and ending '-->'. 
   */
  Comment.prototype = {
  }
  
  /**
   * Represents a type referenced from Element or Attr nodes, specified in the schemas associated 
   * with the document. The type is a pair of a namespace URI and name properties, 
   * and depends on the document's schema. 
   */
  TypeInfo.prototype = {
     /**
      * The name of a type declared for the associated element or attribute, or null if unknown. 
      */
     typeName:0,
     /**
      * The namespace of the type declared for the associated element or attribute or
      * null if the element does not have declaration or if no namespace information is available.  
      */
     typeNamespace:0,
     /**
      * Returns if there is a derivation between the reference type definition, i.e. 
      * the TypeInfo on which the method is being called, and the other type definition, i.e. 
      * the one passed as parameters.  
      * 
      * @param tpNmSpc    The namespace of the other type definition.
      * @param tpNm       The name of the other type definition. 
      * @param drvMeth    The type of derivation and conditions applied between two types, 
      *                   as described in the list of constants provided in this interface.
      * @return   If the document's schema is a DTD or no schema is associated with the document, 
                  this method will always return false. If the document's schema is an XML Schema, 
                  the method will true if the reference type definition is derived from the other 
                  type definition according to the derivation parameter. If the value of 
                  the parameter is 0 (no bit is set to 1 for the derivationMethod parameter), 
                  the method will return true if the other type definition can be reached 
                  by recursing any combination of {base type definition}, {item type definition}, 
                  or {member type definitions} from the reference type definition.  
      */
    isDerivedFrom:function(tpNmSpc, tpNm, drvMeth){}
  }
   
  /**
   * When associating an object to a key on a node using Node.setUserData() the application 
   * can provide a handler that gets called when the node the object is associated to 
   * is being cloned, imported, or renamed. This can be used by the application to implement 
   * various behaviors regarding the data it associates to the DOM nodes. 
   * This interface defines that handler.  
   */
  UserDataHandler.prototype = {
     /**
      * Called whenever the node for which this handler is registered is imported or cloned.  
      * 
      * @param o      Specifies the type of operation that is being performed on the node.
      * @param k      Specifies the key for which this handler is being called. 
      * @param d      Specifies the data for which this handler is being called. 
      * @param src    Specifies the node being cloned, adopted, imported, or renamed. 
      *               This is null when the node is being deleted.
      * @param dst    Specifies the node newly created if any, or null. 
      */
     handle:function(o, k, d, src, dst){}
  }
  
  /**
   * Describes an error. 
   */
  DOMError.prototype = {
     /**
      * The location of the error. 
      */
     location:0,
     /**
      * An implementation specific string describing the error that occurred. 
      */
     message:0,
     /**
      * The related DOMError.type dependent data if any. 
      */
     relatedData:0,
     /**
      * The related platform dependent exception if any. 
      */
     relatedException:0,
     /**
      * The severity of the error, either SEVERITY_WARNING, SEVERITY_ERROR, or SEVERITY_FATAL_ERROR. 
      */
     severity:0,
     /**
      * A  indicating which related data is expected in relatedData. 
      * Users should refer to the specification of the error in order to find its  type 
      * and relatedData definitions if any. 
      */
     type:0
  }
  
  /**
   * It is a callback interface that the DOM implementation can call when reporting errors that 
   * happens while processing XML data, or when doing some other processing (e.g. validating a document). 
   */
  DOMErrorHandler.prototype = {
     /**
      * Called on the error handler when an error occurs.
      * If an exception is thrown from this method, it is considered to be equivalent of returning true.   
      * 
      * @param error  The error object that describes the error. 
      * @return If the handleError method returns false, the DOM implementation should stop 
      *         the current processing when possible. If the method returns true, the processing 
      *         may continue depending on DOMError.severity.     
      */
     handleError:function(error){}
  }
  
  /**
   * Describes a location. 
   */
  DOMLocator.prototype = {
     /**
      * The byte offset into the input source this locator is pointing to 
      * or -1 if there is no byte offset available. 
      */
     byteOffset:0,
     /**
      * The column number this locator is pointing to, or -1 if there is no column number available. 
      */
     columnNumber:0,
     /**
      * The line number this locator is pointing to, or -1 if there is no column number available. 
      */
     lineNumber:0,
     /**
      * The node this locator is pointing to, or null if no node is available. 
      */
     relatedNode:0,
     /**
      * The URI this locator is pointing to, or null if no URI is available. 
      */
     uri:0,
     /**
      * The UTF-16 offset into the input source this locator is pointing to 
      * or -1 if there is no UTF-16 offset available. 
      */
     utf16Offset:0
  }
  
  /**
   * Represents the configuration of a document and maintains a table of recognized parameters.
   */
  DOMConfiguration.prototype = {
      /**
       * The list of the parameters supported by this DOMConfiguration object and 
       * for which at least one value can be set by the application. 
       */
      parameterNames:0,
      /**
       * Checks if setting a parameter to a specific value is supported.
       * 
       * @param n  The name of the parameter to check.
       * @param v  An object. If null, the returned value is true.
       * @return   True if the parameter could be successfully set to the specified value, 
       *           or false if the parameter is not recognized or the requested value is not supported. 
       */
      canSetParameter:function(n, v){},
      /**
       * Returns the value of a parameter if known.
       * 
       * @param name  The name of the parameter.
       * @return      The current object associated with the specified parameter. 
       *              or null if no object has been associated or if the parameter is not supported.                
       */
      getParameter:function(name){},
      /**
       * Sets the value of a parameter.
       * 
       * @param n  The name of the parameter to set.
       * @param v  The new value or null if the user wishes to unset the parameter.
       */
      setParameter:function(n, v){}
  }
  
  /**
   * Used to escape blocks of text containing characters that would otherwise be regarded as markup. 
   */
  CDATASection.prototype = {}
  
  /**
   * Each Document has a doctype attribute whose value is either null or a DocumentType object.
   * The DocumentType interface in the DOM Core provides an interface to the list of entities 
   * that are defined for the document.
   */
  DocumentType.prototype = {
     /**
      * A NamedNodeMap containing the general entities, both external and internal, declared in the DTD. 
      */
     entities:0,
     /**
      * The internal subset as a string, or null if there is none. 
      */
     internalSubset:0,
     /**
      * The name of DTD; i.e., the name immediately following the DOCTYPE keyword. 
      */
     name:0,
     /**
      * A NamedNodeMap containing the notations declared in the DTD. 
      */
     notations:0,
     /**
      * The public identifier of the external subset. 
      */
     publicId:0,
     /**
      * The system identifier of the external subset. This may be an absolute URI or not. 
      */
     systemId:0
  }
  
  /**
   * Represents a notation declared in the DTD. 
   */
  Notation.prototype = {
      /**
       * The public identifier of this notation. If the public identifier was not specified, this is null. 
       */
      publicId:0,
      /**
       * The system identifier of this notation. If the system identifier was not specified, this is null. 
       * This may be an absolute URI or not.
       */
      systemId:0
  }
  
  /**
   * Represents a known entity, either parsed or unparsed, in an XML document.
   */
  Entity.prototype = {
     /**
      * An attribute specifying the encoding used for this entity at the time of parsing, 
      * when it is an external parsed entity. This is null if it an entity from the internal subset 
      * or if it is not known. 
      */
     inputEncoding:0,
     /**
      * For unparsed entities, the name of the notation for the entity. For parsed entities, this is null. 
      */
     notationName :0,
     /**
      * The public identifier associated with the entity if specified, and null otherwise. 
      */
     publicId:0,
     /**
      * The system identifier associated with the entity if specified, and null otherwise. 
      * This may be an absolute URI or not. 
      */
     systemId:0,
     /**
      * An attribute specifying, as part of the text declaration, the encoding of this entity, 
      * when it is an external parsed entity. This is null otherwise. 
      */
     xmlEncoding:0,
     /**
      * An attribute specifying, as part of the text declaration, the version number of this entity, 
      * when it is an external parsed entity. This is null otherwise. 
      */
     xmlVersion:0
  }
  
  /**
   * EntityReference nodes may be used to represent an entity reference in the tree.
   */
  EntityReference.prototype = {}
  
  /**
   * Represents a "processing instruction", used in XML as a way to keep 
   * processor-specific information in the text of the document.
   */
  ProcessingInstruction.prototype = {
     /**
      * The content of this processing instruction. 
      */
     data:0,
     /**
      * The target of this processing instruction. XML defines this as being the first token 
      * following the markup that begins the processing instruction. 
      */
     target:0
  } 