<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match="/">
        <entries>
            <xsl:for-each select="api/entries/entry">
                <xsl:variable name="func_type">
                    <xsl:value-of select="@type"/>
                </xsl:variable>
                <xsl:variable name="func_name">
                    <xsl:value-of select="@name"/>
                </xsl:variable>
                <xsl:variable name="func_return">
                    <xsl:value-of select="@return"/>
                </xsl:variable>
                <xsl:variable name="func_descr">
                    <xsl:value-of select="desc"/>
                </xsl:variable>
                <xsl:for-each select="signature">
                    <xsl:if test="$func_type='method'">
                        <function>
                            <xsl:attribute name="name">
                                <xsl:copy-of select="$func_name"/>
                            </xsl:attribute>
                            <documentation>
                                <xsl:copy-of select="$func_descr"/>
                            </documentation>
                            <signature>
                                <xsl:for-each select="argument">
                                    <parameter>
                                        <xsl:attribute name="name">
                                            <xsl:value-of select="@name"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="optional">
                                            <xsl:value-of select="@optional"/>
                                        </xsl:attribute>
                                        <documentation>
                                            <xsl:value-of select="desc"/>
                                        </documentation>
                                    </parameter>
                                </xsl:for-each>
                                <return>
                                    <xsl:copy-of select="$func_return"/>
                                </return>
                            </signature>
                        </function>
                    </xsl:if>
                    <xsl:if test="$func_type='property'">
                        <property>
                            <xsl:attribute name="name">
                                <xsl:copy-of select="$func_name"/>
                            </xsl:attribute>
                            <documentation>
                                <xsl:copy-of select="$func_descr"/>
                            </documentation>
                            <signature>
                                <xsl:for-each select="argument">
                                    <parameter>
                                        <xsl:attribute name="name">
                                            <xsl:value-of select="@name"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="optional">
                                            <xsl:value-of select="@optional"/>
                                        </xsl:attribute>
                                        <documentation>
                                            <xsl:value-of select="desc"/>
                                        </documentation>
                                    </parameter>
                                </xsl:for-each>
                                <return>
                                    <xsl:copy-of select="$func_return"/>
                                </return>
                            </signature>
                        </property>
                    </xsl:if>
                    <xsl:if test="$func_type='selector'">
                        <selector>
                            <xsl:attribute name="name">
                                <xsl:copy-of select="$func_name"/>
                            </xsl:attribute>
                            <documentation>
                                <xsl:copy-of select="$func_descr"/>
                            </documentation>
                            <signature>
                                <xsl:for-each select="argument">
                                    <parameter>
                                        <xsl:attribute name="name">
                                            <xsl:value-of select="@name"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="optional">
                                            <xsl:value-of select="@optional"/>
                                        </xsl:attribute>
                                        <documentation>
                                            <xsl:value-of select="desc"/>
                                        </documentation>
                                    </parameter>
                                </xsl:for-each>
                                <return>
                                    <xsl:copy-of select="$func_return"/>
                                </return>
                            </signature>
                        </selector>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </entries>
    </xsl:template>
</xsl:stylesheet>
